// PdfOcxDemoDlg.h : ͷļ
//

#pragma once
#include "Markup.h"
#include "afxwin.h"
#include "PDFCtrl.h"
#include "SetIntervalDlg.h"

// CPdfOcxDemoDlg Ի
class CPdfOcxDemoDlg : public CDialog
{
// 
public:
	CPdfOcxDemoDlg(CWnd* pParent = NULL);	// ׼캯

// Ի
	enum { IDD = IDD_PDFOCXDEMO_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV ֧

private:
    afx_msg LRESULT OnAutoPageSetup(WPARAM /*wParam*/, LPARAM /*lParam*/);

    afx_msg void OnClickedOpen();
    afx_msg void OnClickedClose();
    afx_msg void OnMenuBookmarkInsert();
    afx_msg void OnMenuBookmarkGoto();
    afx_msg void OnClickedPrevious();
    afx_msg void OnClickedNext();
    afx_msg void OnClickedSingle();
    afx_msg void OnClickedDouble();
    afx_msg void OnClickedAutoPage();
    afx_msg void OnClickedColor();

    afx_msg void OnMenuGotoFirst();
    afx_msg void OnMenuGotoLast();
    afx_msg void OnMenuColorFont();
    afx_msg void OnMenuColorPaper();
    afx_msg void OnMenuColorBackground();
    afx_msg void OnMenuColorDefault();

    afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/);
    afx_msg void OnTimer(UINT_PTR nIDEvent);
    afx_msg void OnSize(UINT nType, int cx, int cy);

    afx_msg void OnClickedFind();
    afx_msg void OnClickedFindPrevious();
    afx_msg void OnClickedFindNext();

private:
    virtual BOOL PreTranslateMessage(MSG* pMsg);

// ʵ
protected:
	HICON m_hIcon;

	// ɵϢӳ亯
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	DECLARE_MESSAGE_MAP()

private:
    void InitXmlAnalyzer();
    void InitToolbar();    
    void CreateDisplayModeBox();
    void CreatePageBox();
    void UpdateUI();
    void UpdatePageBox();
    void UpdateScrollbar();
    void CreateFindBox();
    BOOL IsPtInLeftRect(RECT *lprc, WORD x);
    BOOL LoadBookmark();

private:
    CToolBar    m_wndToolbar;
    CButton     m_bnSingle;
    CButton     m_bnDouble;
    CButton     m_bnAutoPage;
    CEdit       m_ctrlPage;
    CEdit       m_ctrlFind;
    CButton     m_bnFindPrev;
    CButton     m_bnFindNext;
    CStatic     m_ctrlPageCount;
    CScrollBar  m_ctrlVScrollbar;
    CPdfCtrl    m_ctrlPdf;
    CSetIntervalDlg  m_dlgSetInterval;

    CMarkup     m_objXml;
    CString     m_strBookmarkPage;
    CString     m_strURI;
    CString     m_strLastKeyword;
    CString     m_strXMLPath;
    afx_msg void OnDestroy();
};
